namespace Dzek_Vrabac
{
    internal class Program
    {
        public static void UnosPodataka(out int n, out int[] x, out int[] h)
        {
            n = int.Parse(Console.ReadLine());
            x = Array.ConvertAll(Console.ReadLine().Trim().Split(' '), int.Parse);
            h = Array.ConvertAll(Console.ReadLine().Trim().Split(' '), int.Parse);
        }

        public static int[] RacunanjeOpadanjaSvakogKonopca(int n, int[] x, int[] h)
        {
            int[] rezultat = new int[n - 1];

            for (int i = 0; i < n - 1; i++)
            {
                // Izracunavanje razlike u visini i udaljenosti izmedju jarbola
                int razlikaUVisini = h[i + 1] - h[i];
                int udaljenostJarbola = x[i + 1] - x[i];

                // Racunanje kolko dugo konopac pada
                int opada = (udaljenostJarbola - razlikaUVisini) / 2;

                // Cuvanje rezultata
                rezultat[i] = opada;
            }

            return rezultat;
        }

        public static void PopunjavanjeUdaljenosti(int n, ref int[] rezultat)
        {
            for(int i = 0; i < n; i++)
            {
                rezultat[i] = -1;
            }
        }

        public static int[] NajbliziDeo(int n, int[] x, int[] h, int[] opadanjeSvakogKonopca)
        {
            int[] rezultat = new int[n];

            // Popunjavanje rezultata sa -1
            PopunjavanjeUdaljenosti(n, ref rezultat);

            // Prolazak kroz sve jarbole
            for (int i = 0; i < n; i++)
            {
                // Prolazak korz sve konopce
                for (int j = 0; j < n - 1; j++)
                {
                    if (h[i] <= h[j])
                    {
                        // Racunanje udaljenosti
                        int udaljenost = Math.Abs(h[i] - h[j] + 2 * opadanjeSvakogKonopca[j] + x[j] - x[i]);

                        // Cuvanje rezultata
                        if (i <= j)
                        {
                            if(udaljenost < rezultat[i] || rezultat[i] == -1) rezultat[i] = udaljenost;
                            else break;
                        }
                        else
                        {
                            if (udaljenost < rezultat[i] || rezultat[i] == -1) rezultat[i] = udaljenost;
                        }
                    }
                }
            }

            return rezultat;
        }

        public static void IspisRezultata(int[] rezultat)
        {
            foreach(int i in rezultat)
            {
                Console.WriteLine(i);
            }
        }

        static void Main(string[] args)
        {
            // Unos podataka
            UnosPodataka(out int n, out int[] x, out int[] h);

            // Racunanje opadanja svakog konopca
            int[] opadanjeSvakogKonopca = RacunanjeOpadanjaSvakogKonopca(n, x, h);

            // Racunanje najblizih delova
            int[] najbliziDeo = NajbliziDeo(n, x, h, opadanjeSvakogKonopca);

            // Ispis rezultata
            IspisRezultata(najbliziDeo);
        }
    }
}